Scriptname lbEffectMeleeScript Extends ActiveMagicEffect

Actor MySelf
Float RestoreValue


Event OnEffectStart(Actor akTarget, Actor akCaster)
	MySelf = akTarget
	Float fAmount = MySelf.GetBaseActorValue("Stamina")
	MySelf.RestoreActorValue("Stamina", fAmount)
	RestoreValue = fAmount * 0.1
	RegisterForSingleUpdate(1.0)

	Int h = ModEvent.Create("lbPlayerFrenzy")

	if h
		ModEvent.PushInt(h, 1)
		ModEvent.Send(h)
	endif
EndEvent


Event OnEffectFinish(Actor akTarget, Actor akCaster)
	Int h = ModEvent.Create("lbPlayerFrenzy")

	if h
		ModEvent.PushInt(h, 0)
		ModEvent.Send(h)
	endif
EndEvent


Event OnUpdate()
	MySelf.RestoreActorValue("Stamina", RestoreValue)
	RegisterForSingleUpdate(1.0)
EndEvent